```javascript
class CustomAdminNavbar extends HTMLElement {
  connectedCallback() {
    this.attachShadow({ mode: 'open' });
    this.shadowRoot.innerHTML = `
      <style>
        :host {
          display: block;
          position: fixed;
          top: 0;
          right: 0;
          left: 0;
          z-index: 50;
          background: white;
          box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        .navbar {
          display: flex;
          justify-content: space-between;
          align-items: center;
          padding: 1rem 2rem;
        }
        .logo {
          font-weight: bold;
          font-size: 1.25rem;
          color: #4f46e5;
        }
        .user-menu {
          display: flex;
          align-items: center;
          gap: 1rem;
        }
        .user-avatar {
          width: 40px;
          height: 40px;
          border-radius: 50%;
          object-fit: cover;
        }
        .sidebar {
          position: fixed;
          top: 0;
          right: 0;
          bottom: 0;
          width: 16rem;
          background: #4f46e5;
          color: white;
          padding-top: 5rem;
          transform: translateX(0);
          transition: transform 0.3s ease;
        }
        .sidebar.hidden {
          transform: translateX(100%);
        }
        .sidebar-menu {
          list-style: none;
          padding: 0;
          margin: 0;
        }
        .sidebar-menu li a {
          display: block;
          padding: 0.75rem 1.5rem;
          color: white;
          text-decoration: none;
          transition: background 0.3s;
        }
        .sidebar-menu li a:hover {
          background: rgba(255,255,255,0.1);
        }
        .sidebar-menu li a i {
          margin-left: 0.5rem;
        }
        .mobile-menu-btn {
          display: none;
        }
        @media (max-width: 768px) {
          .sidebar {
            transform: translateX(100%);
          }
          .sidebar.open {
            transform: translateX(0);
          }
          .mobile-menu-btn {
            display: block;
          }
        }
      </style>
      <div class="navbar">
        <div class="flex items-center gap-4">
          <button class="mobile-menu-btn" id="menu-toggle">
            <i data-feather="menu"></i>
          </button>
          <a href="admin-dashboard.html" class="logo">EduSphere</a>
        </div>
        <div class="user-menu">
          <img src="http://static.photos/people/200x200/3" alt="User" class="user-avatar">
          <span>أد